<?php 

namespace App\Exports;
use App\Models\Layanan_Adm_Gsd;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
class LayananAdmGsdListExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
	
	protected $query;
	
    public function __construct($query)
    {
        $this->query = $query->select(Layanan_Adm_Gsd::exportListFields());
    }
	
    public function query()
    {
        return $this->query;
    }
	
	public function headings(): array
    {
        return [
			'Created',
			'Id Jenis Layanan Adm Gsd',
			'Jumlah',
			'Modified'
        ];
    }
	
    public function map($record): array
    {
        return [
			$record->created,
			$record->id_jenis_layanan_adm_gsd,
			$record->jumlah,
			$record->modified
        ];
    }
}
