<?php 

namespace App\Exports;
use App\Models\Layanan_Cetak_Kia_Ktp_Paket;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
class LayananCetakKiaKtpPaketListExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
	
	protected $query;
	
    public function __construct($query)
    {
        $this->query = $query->select(Layanan_Cetak_Kia_Ktp_Paket::exportListFields());
    }
	
    public function query()
    {
        return $this->query;
    }
	
	public function headings(): array
    {
        return [
			'Created',
			'Id Jenis Layanan Cetak Kia Ktp Paket',
			'Jumlah',
			'Modified'
        ];
    }
	
    public function map($record): array
    {
        return [
			$record->created,
			$record->id_jenis_layanan_cetak_kia_ktp_paket,
			$record->jumlah,
			$record->modified
        ];
    }
}
