<?php 

namespace App\Exports;
use App\Models\Layanan_Informasi_Offline;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
class LayananInformasiOfflineListExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
	
	protected $query;
	
    public function __construct($query)
    {
        $this->query = $query->select(Layanan_Informasi_Offline::exportListFields());
    }
	
    public function query()
    {
        return $this->query;
    }
	
	public function headings(): array
    {
        return [
			'Created',
			'Id Jenis Layanan Informasi Offline',
			'Jumlah',
			'Modified'
        ];
    }
	
    public function map($record): array
    {
        return [
			$record->created,
			$record->id_jenis_layanan_informasi_offline,
			$record->jumlah,
			$record->modified
        ];
    }
}
