<?php 

namespace App\Exports;
use App\Models\Layanan_Verifikator;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
class LayananVerifikatorListExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
	
	protected $query;
	
    public function __construct($query)
    {
        $this->query = $query->select(Layanan_Verifikator::exportListFields());
    }
	
    public function query()
    {
        return $this->query;
    }
	
	public function headings(): array
    {
        return [
			'Created',
			'Id Jenis Layanan Verifikator',
			'Jumlah',
			'Modified'
        ];
    }
	
    public function map($record): array
    {
        return [
			$record->created,
			$record->id_jenis_layanan_verifikator,
			$record->jumlah,
			$record->modified
        ];
    }
}
