<?php 

namespace App\Exports;
use App\Models\Layanan_Wa_Pengaduan;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
class LayananWaPengaduanListExport implements FromQuery, WithHeadings, WithMapping, ShouldAutoSize
{
	
	protected $query;
	
    public function __construct($query)
    {
        $this->query = $query->select(Layanan_Wa_Pengaduan::exportListFields());
    }
	
    public function query()
    {
        return $this->query;
    }
	
	public function headings(): array
    {
        return [
			'Created',
			'Id Jenis Layanan Wa Pengaduan',
			'Jumlah',
			'Modified'
        ];
    }
	
    public function map($record): array
    {
        return [
			$record->created,
			$record->id_jenis_layanan_wa_pengaduan,
			$record->jumlah,
			$record->modified
        ];
    }
}
