<?php 
namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use App\Http\Requests\Jenis_Layanan_Cetak_Kia_Ktp_PaketAddRequest;
use App\Http\Requests\Jenis_Layanan_Cetak_Kia_Ktp_PaketEditRequest;
use App\Models\Jenis_Layanan_Cetak_Kia_Ktp_Paket;
use Illuminate\Http\Request;
use Exception;
class Jenis_Layanan_Cetak_Kia_Ktp_PaketController extends Controller
{
	

	/**
     * List table records
	 * @param  \Illuminate\Http\Request
     * @param string $fieldname //filter records by a table field
     * @param string $fieldvalue //filter value
     * @return \Illuminate\View\View
     */
	function index(Request $request, $fieldname = null , $fieldvalue = null){
		$view = "pages.jenis_layanan_cetak_kia_ktp_paket.list";
		$query = Jenis_Layanan_Cetak_Kia_Ktp_Paket::query();
		$limit = $request->limit ?? 10;
		if($request->search){
			$search = trim($request->search);
			Jenis_Layanan_Cetak_Kia_Ktp_Paket::search($query, $search); // search table records
		}
		if($request->orderby){
			$orderby = $request->orderby;
			$ordertype = ($request->ordertype ? $request->ordertype : "desc");
			$query->orderBy($orderby, $ordertype);
		}
		else{
			$query->orderBy("jenis_layanan_cetak_kia_ktp_paket.id", "ASC");
		}
		if($fieldname){
			$query->where($fieldname , $fieldvalue); //filter by a table field
		}
		$records = $query->paginate($limit, Jenis_Layanan_Cetak_Kia_Ktp_Paket::listFields());
		return $this->renderView($view, compact("records"));
	}
	

	/**
     * Select table record by ID
	 * @param string $rec_id
     * @return \Illuminate\View\View
     */
	function view($rec_id = null){
		$query = Jenis_Layanan_Cetak_Kia_Ktp_Paket::query();
		$record = $query->findOrFail($rec_id, Jenis_Layanan_Cetak_Kia_Ktp_Paket::viewFields());
		return $this->renderView("pages.jenis_layanan_cetak_kia_ktp_paket.view", ["data" => $record]);
	}
	

	/**
     * Display form page
     * @return \Illuminate\View\View
     */
	function add(){
		return $this->renderView("pages.jenis_layanan_cetak_kia_ktp_paket.add");
	}
	

	/**
     * Save form record to the table
     * @return \Illuminate\Http\Response
     */
	function store(Jenis_Layanan_Cetak_Kia_Ktp_PaketAddRequest $request){
		$modeldata = $this->normalizeFormData($request->validated());
		
		//save Jenis_Layanan_Cetak_Kia_Ktp_Paket record
		$record = Jenis_Layanan_Cetak_Kia_Ktp_Paket::create($modeldata);
		$rec_id = $record->id;
		return $this->redirect("jenis_layanan_cetak_kia_ktp_paket", "Record added successfully");
	}
	

	/**
     * Update table record with form data
	 * @param string $rec_id //select record by table primary key
     * @return \Illuminate\View\View;
     */
	function edit(Jenis_Layanan_Cetak_Kia_Ktp_PaketEditRequest $request, $rec_id = null){
		$query = Jenis_Layanan_Cetak_Kia_Ktp_Paket::query();
		$record = $query->findOrFail($rec_id, Jenis_Layanan_Cetak_Kia_Ktp_Paket::editFields());
		if ($request->isMethod('post')) {
			$modeldata = $this->normalizeFormData($request->validated());
			$record->update($modeldata);
			return $this->redirect("jenis_layanan_cetak_kia_ktp_paket", "Record updated successfully");
		}
		return $this->renderView("pages.jenis_layanan_cetak_kia_ktp_paket.edit", ["data" => $record, "rec_id" => $rec_id]);
	}
	

	/**
     * Delete record from the database
	 * Support multi delete by separating record id by comma.
	 * @param  \Illuminate\Http\Request
	 * @param string $rec_id //can be separated by comma 
     * @return \Illuminate\Http\Response
     */
	function delete(Request $request, $rec_id = null){
		$arr_id = explode(",", $rec_id);
		$query = Jenis_Layanan_Cetak_Kia_Ktp_Paket::query();
		$query->whereIn("id", $arr_id);
		$query->delete();
		$redirectUrl = $request->redirect ?? url()->previous();
		return $this->redirect($redirectUrl, "Record deleted successfully");
	}
}
