<!-- 
expose component model to current view
e.g $arrDataFromDb = $comp_model->fetchData(); //function name
-->
@inject('comp_model', 'App\Models\ComponentsData')
<?php
    $pageTitle = "Add New Layanan Cetak Kia Ktp Paket"; //set dynamic page title
?>
@extends($layout)
@section('title', $pageTitle)
@section('content')
<section class="page" data-page-type="add" data-page-url="{{ url()->full() }}">
    <?php
        if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3" >
        <div class="container">
            <div class="row align-items-center">
                <div class="col-auto  back-btn-col" >
                    <a class="back-btn btn " href="{{ url()->previous() }}" >
                        <i class="fa fa-angle-left"></i>                                
                    </a>
                </div>
                <div class="col col-md-auto  " >
                    <div class=" h5 font-weight-bold text-primary" >
                        Add New Layanan Cetak Kia Ktp Paket
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
        }
    ?>
    <div  class="" >
        <div class="container">
            <div class="row ">
                <div class="col-md-9 comp-grid " >
                    <?php Html::display_page_errors($errors); ?>
                    <div  class="card-1 border rounded page-content" >
                        <!--[form-start]-->
                        <form id="layanan_cetak_kia_ktp_paket-add-form" role="form" novalidate enctype="multipart/form-data" class="form page-form form-horizontal needs-validation" action="{{ route('layanan_cetak_kia_ktp_paket.store') }}" method="post">
                            @csrf
                            <div>
                                <div class="form-group ">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <label class="control-label" for="id_jenis_layanan_cetak_kia_ktp_paket">Id Jenis Layanan Cetak Kia Ktp Paket </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <div id="ctrl-id_jenis_layanan_cetak_kia_ktp_paket-holder" class=" ">
                                                <input id="ctrl-id_jenis_layanan_cetak_kia_ktp_paket" data-field="id_jenis_layanan_cetak_kia_ktp_paket"  value="<?php echo get_value('id_jenis_layanan_cetak_kia_ktp_paket') ?>" type="number" placeholder="Enter Id Jenis Layanan Cetak Kia Ktp Paket" step="any"  name="id_jenis_layanan_cetak_kia_ktp_paket"  class="form-control " />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <label class="control-label" for="jumlah">Jumlah </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <div id="ctrl-jumlah-holder" class=" ">
                                                <input id="ctrl-jumlah" data-field="jumlah"  value="<?php echo get_value('jumlah') ?>" type="number" placeholder="Enter Jumlah" step="any"  name="jumlah"  class="form-control " />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <label class="control-label" for="created">Created </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <div id="ctrl-created-holder" class="input-group ">
                                                <input id="ctrl-created" data-field="created" class="form-control datepicker  datepicker"  value="<?php echo get_value('created') ?>" type="datetime" name="created" placeholder="Enter Created" data-enable-time="false" data-min-date="" data-max-date="" data-date-format="Y-m-d" data-alt-format="F j, Y" data-inline="false" data-no-calendar="false" data-mode="single" />
                                                <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <label class="control-label" for="modified">Modified </label>
                                        </div>
                                        <div class="col-sm-8">
                                            <div id="ctrl-modified-holder" class="input-group ">
                                                <input id="ctrl-modified" data-field="modified" class="form-control datepicker  datepicker"  value="<?php echo get_value('modified') ?>" type="datetime" name="modified" placeholder="Enter Modified" data-enable-time="false" data-min-date="" data-max-date="" data-date-format="Y-m-d" data-alt-format="F j, Y" data-inline="false" data-no-calendar="false" data-mode="single" />
                                                <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-ajax-status"></div>
                            <!--[form-button-start]-->
                            <div class="form-group form-submit-btn-holder text-center mt-3">
                                <button class="btn btn-primary" type="submit">
                                Submit
                                <i class="fa fa-send"></i>
                                </button>
                            </div>
                            <!--[form-button-end]-->
                        </form>
                        <!--[form-end]-->
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
<!-- Page custom css -->
@section('pagecss')
<style>

</style>
@endsection
<!-- Page custom js -->
@section('pagejs')
<script>
    
$(document).ready(function(){
	// custom javascript | jquery codes
});

</script>
@endsection
