<!-- 
expose component model to current view
e.g $arrDataFromDb = $comp_model->fetchData(); //function name
-->
@inject('comp_model', 'App\Models\ComponentsData')
<?php
    $pageTitle = "Edit Layanan Gsd"; //set dynamic page title
?>
@extends($layout)
@section('title', $pageTitle)
@section('content')
<section class="page" data-page-type="edit" data-page-url="{{ url()->full() }}">
    <?php
        if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3" >
        <div class="container">
            <div class="row align-items-center">
                <div class="col-auto  back-btn-col" >
                    <a class="back-btn btn " href="{{ url()->previous() }}" >
                        <i class="fa fa-angle-left"></i>                                
                    </a>
                </div>
                <div class="col col-md-auto  " >
                    <div class=" h5 font-weight-bold text-primary" >
                        Edit Layanan Gsd
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php
        }
    ?>
    <div  class="" >
        <div class="container">
            <div class="row ">
                <div class="col-md-9 comp-grid " >
                    <?php Html::display_page_errors($errors); ?>
                    <div  class="card-1 border rounded page-content" >
                        <!--[form-start]-->
                        <form novalidate  id="" role="form" enctype="multipart/form-data"  class="form page-form form-horizontal needs-validation" action="<?php print_link("layanan_gsd/edit/$rec_id"); ?>" method="post">
                        <!--[form-content-start]-->
                        @csrf
                        <div>
                            <div class="form-group ">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <label class="control-label" for="id_jenis_layanan_gsd">Id Jenis Layanan Gsd </label>
                                    </div>
                                    <div class="col-sm-8">
                                        <div id="ctrl-id_jenis_layanan_gsd-holder" class=" ">
                                            <input id="ctrl-id_jenis_layanan_gsd" data-field="id_jenis_layanan_gsd"  value="<?php  echo $data['id_jenis_layanan_gsd']; ?>" type="number" placeholder="Enter Id Jenis Layanan Gsd" step="any"  name="id_jenis_layanan_gsd"  class="form-control " />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group ">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <label class="control-label" for="jumlah">Jumlah </label>
                                    </div>
                                    <div class="col-sm-8">
                                        <div id="ctrl-jumlah-holder" class=" ">
                                            <input id="ctrl-jumlah" data-field="jumlah"  value="<?php  echo $data['jumlah']; ?>" type="number" placeholder="Enter Jumlah" step="any"  name="jumlah"  class="form-control " />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group ">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <label class="control-label" for="created">Created </label>
                                    </div>
                                    <div class="col-sm-8">
                                        <div id="ctrl-created-holder" class="input-group ">
                                            <input id="ctrl-created" data-field="created" class="form-control datepicker  datepicker"  value="<?php  echo $data['created']; ?>" type="datetime" name="created" placeholder="Enter Created" data-enable-time="false" data-min-date="" data-max-date="" data-date-format="Y-m-d" data-alt-format="F j, Y" data-inline="false" data-no-calendar="false" data-mode="single" />
                                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group ">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <label class="control-label" for="modified">Modified </label>
                                    </div>
                                    <div class="col-sm-8">
                                        <div id="ctrl-modified-holder" class="input-group ">
                                            <input id="ctrl-modified" data-field="modified" class="form-control datepicker  datepicker"  value="<?php  echo $data['modified']; ?>" type="datetime" name="modified" placeholder="Enter Modified" data-enable-time="false" data-min-date="" data-max-date="" data-date-format="Y-m-d" data-alt-format="F j, Y" data-inline="false" data-no-calendar="false" data-mode="single" />
                                            <span class="input-group-text"><i class="fa fa-calendar"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-ajax-status"></div>
                        <!--[form-content-end]-->
                        <!--[form-button-start]-->
                        <div class="form-group text-center">
                            <button class="btn btn-primary" type="submit">
                            Update
                            <i class="fa fa-send"></i>
                            </button>
                        </div>
                        <!--[form-button-end]-->
                    </form>
                    <!--[form-end]-->
                </div>
            </div>
        </div>
    </div>
</div>
</section>
@endsection
<!-- Page custom css -->
@section('pagecss')
<style>

</style>
@endsection
<!-- Page custom js -->
@section('pagejs')
<script>
    <!--pageautofill-->
$(document).ready(function(){
	// custom javascript | jquery codes
});

</script>
@endsection
