<!-- 
expose component model to current view
e.g $arrDataFromDb = $comp_model->fetchData(); //function name
-->
@inject('comp_model', 'App\Models\ComponentsData')
<?php
    $field_name = request()->segment(3);
    $field_value = request()->segment(4);
    $total_records = $records->total();
    $limit = $records->perPage();
    $record_count = count($records);
    $pageTitle = "Layanan Kecamatan"; //set dynamic page title
?>
@extends($layout)
@section('title', $pageTitle)
@section('content')
<section class="page" data-page-type="list" data-page-url="{{ url()->full() }}">
    <?php
        if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3" >
        <div class="container-fluid">
            <div class="row justify-content-between align-items-center">
                <div class="col col-md-auto  " >
                    <div class=" h5 font-weight-bold text-primary" >
                        Layanan Kecamatan
                    </div>
                </div>
                <div class="col-md-auto  " >
                    <a  class="btn btn-primary" href="<?php print_link("layanan_kecamatan/add", true) ?>" >
                    <i class="fa fa-plus"></i>                              
                    Add New Layanan Kecamatan 
                </a>
            </div>
            <div class="col-md-3  " >
                <!-- Page drop down search component -->
                <form  class="search" action="{{ url()->current() }}" method="get">
                    <input type="hidden" name="page" value="1" />
                    <div class="input-group">
                        <input value="<?php echo get_value('search'); ?>" class="form-control page-search" type="text" name="search"  placeholder="Search" />
                        <button class="btn btn-primary"><i class="fa fa-search"></i></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php
    }
?>
<div  class="d-none" >
    <div class="container-fluid">
        <div class="row ">
            <div class="col-md-12 comp-grid " >
                <?php Html::display_page_errors($errors); ?>
                <div  class=" page-content" >
                    <div id="layanan_kecamatan-customchart-records">
                        <div id="page-main-content" class="table-responsive">
                            <?php Html::page_bread_crumb("/layanan_kecamatan/customchart", $field_name, $field_value); ?>
                            <table class="table table-hover table-striped table-sm text-left">
                                <thead class="table-header ">
                                    <tr>
                                        <th class="td-checkbox">
                                        <label class="form-check-label">
                                        <input class="toggle-check-all form-check-input" type="checkbox" />
                                        </label>
                                        </th>
                                        <th class="td-id" > Id</th>
                                        <th class="td-id_kecamatan" > Id Kecamatan</th>
                                        <th class="td-id_jenis_layanan_kecamatan" > Id Jenis Layanan Kecamatan</th>
                                        <th class="td-jumlah" > Jumlah</th>
                                        <th class="td-created" > Created</th>
                                        <th class="td-modified" > Modified</th>
                                        <th class="td-btn"></th>
                                    </tr>
                                </thead>
                                <?php
                                    if($total_records){
                                ?>
                                <tbody class="page-data">
                                    <!--record-->
                                    <?php
                                        $counter = 0;
                                        foreach($records as $data){
                                        $rec_id = ($data['id'] ? urlencode($data['id']) : null);
                                        $counter++;
                                    ?>
                                    <tr>
                                        <td class=" td-checkbox">
                                            <label class="form-check-label">
                                            <input class="optioncheck form-check-input" name="optioncheck[]" value="<?php echo $data['id'] ?>" type="checkbox" />
                                            </label>
                                        </td>
                                        <!--PageComponentStart-->
                                        <td class="td-id">
                                            <a href="<?php print_link("layanan_kecamatan/view/$data[id]") ?>"><?php echo $data['id']; ?></a>
                                        </td>
                                        <td class="td-id_kecamatan">
                                            <?php echo  $data['id_kecamatan'] ; ?>
                                        </td>
                                        <td class="td-id_jenis_layanan_kecamatan">
                                            <?php echo  $data['id_jenis_layanan_kecamatan'] ; ?>
                                        </td>
                                        <td class="td-jumlah">
                                            <?php echo  $data['jumlah'] ; ?>
                                        </td>
                                        <td class="td-created">
                                            <?php echo  $data['created'] ; ?>
                                        </td>
                                        <td class="td-modified">
                                            <?php echo  $data['modified'] ; ?>
                                        </td>
                                        <!--PageComponentEnd-->
                                        <td class="td-btn">
                                            <div class="dropdown" >
                                                <button data-bs-toggle="dropdown" class="dropdown-toggle btn text-primary btn-flat btn-sm">
                                                <i class="fa fa-bars"></i> 
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <a class="dropdown-item "   href="<?php print_link("layanan_kecamatan/view/$rec_id"); ?>" >
                                                    <i class="fa fa-eye"></i> View
                                                </a>
                                                <a class="dropdown-item "   href="<?php print_link("layanan_kecamatan/edit/$rec_id"); ?>" >
                                                <i class="fa fa-edit"></i> Edit
                                            </a>
                                            <a class="dropdown-item record-delete-btn" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal" href="<?php print_link("layanan_kecamatan/delete/$rec_id"); ?>" >
                                            <i class="fa fa-times"></i> Delete
                                        </a>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php 
                            }
                        ?>
                        <!--endrecord-->
                    </tbody>
                    <tbody class="search-data"></tbody>
                    <?php
                        }
                        else{
                    ?>
                    <tbody class="page-data">
                        <tr>
                            <td class="bg-light text-center text-muted animated bounce p-3" colspan="1000">
                                <i class="fa fa-ban"></i> No record found
                            </td>
                        </tr>
                    </tbody>
                    <?php
                        }
                    ?>
                </table>
            </div>
            <?php
                if($show_footer){
            ?>
            <div class=" mt-3">
                <div class="row align-items-center justify-content-between">    
                    <div class="col-md-auto justify-content-center">    
                        <div class="d-flex justify-content-start">  
                            <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("layanan_kecamatan/delete/{sel_ids}"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                            <i class="fa fa-times"></i> Delete Selected
                            </button>
                        </div>
                    </div>
                    <div class="col">   
                        <?php
                            if($show_pagination == true){
                            $pager = new Pagination($total_records, $record_count);
                            $pager->show_page_count = false;
                            $pager->show_record_count = true;
                            $pager->show_page_limit =false;
                            $pager->limit = $limit;
                            $pager->show_page_number_list = true;
                            $pager->pager_link_range=5;
                            $pager->render();
                            }
                        ?>
                    </div>
                </div>
            </div>
            <?php
                }
            ?>
        </div>
    </div>
</div>
</div>
</div>
</div>
<div  class="bg-light p-3 mb-3" >
    <div class="container-fluid">
        <div class="row ">
            <div class="col-12 comp-grid " >
                <div class="card ">
                    <div >
                        <div class="card-header p-0 pt-2 px-2">
                            <ul class="nav  nav-tabs   ">
                                <li class="nav-item">
                                    <a class="nav-link active" data-bs-toggle="tab" href="#TabPage503Page1" role="tab" aria-selected="true">
                                        Bulan Berjalan
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link " data-bs-toggle="tab" href="#TabPage503Page2" role="tab" aria-selected="true">
                                        Tab 2
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <div class="tab-content">
                                <div class="tab-pane show active fade" id="TabPage503Page1" role="tabpanel" >
                                    <!--Include chart component-->
                                    @include("pages.grafik_layanan_kecamatan---php-setlocale-lc_all---id-id----id_id----------jumlah-cetak-e-ktp-wni-------strftime---b------")
                                    <!--Include chart component-->
                                    @include("pages.grafik_layanan_kecamatan-jumlah-perekaman-baru-di-atas-17-tahun-------strftime---b------")
                                    <!--Include chart component-->
                                    @include("pages.grafik_layanan_kecamatan-jumlah-cetak-kia-------strftime---b------")
                                    <!--Include chart component-->
                                    @include("pages.grafik_layanan_kecamatan-sisa-blanko-wni-per-hari-------strftime---b------")
                                    <!--Include chart component-->
                                    @include("pages.grafik_layanan_kecamatan-sisa-blanko-wna-per-hari-------strftime---b------")
                                </div>
                                <div class="tab-pane  fade" id="TabPage503Page2" role="tabpanel" >
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</section>
@endsection
<!-- Page custom css -->
@section('pagecss')
<style>

</style>
@endsection
<!-- Page custom js -->
@section('pagejs')
<script>
    <!--pageautofill-->
$(document).ready(function(){
	// custom javascript | jquery codes
});

$(document).ready(function(){
	// custom javascript | jquery codes
});

</script>
@endsection
