<!-- 
expose component model to current view
e.g $arrDataFromDb = $comp_model->fetchData(); //function name
-->
@inject('comp_model', 'App\Models\ComponentsData')
<?php
    $field_name = request()->segment(3);
    $field_value = request()->segment(4);
    $total_records = $records->total();
    $limit = $records->perPage();
    $record_count = count($records);
    $pageTitle = "Layanan Wa Pengaduan"; //set dynamic page title
?>
@extends($layout)
@section('title', $pageTitle)
@section('content')
<section class="page" data-page-type="list" data-page-url="{{ url()->full() }}">
    <?php
        if( $show_header == true ){
    ?>
    <div  class="bg-light p-3 mb-3" >
        <div class="container-fluid">
            <div class="row justify-content-between align-items-center">
                <div class="col col-md-auto  " >
                    <div class=" h5 font-weight-bold text-primary" >
                        Layanan Wa Pengaduan
                    </div>
                </div>
                <div class="col-md-auto comp-grid " >
                    <div class=" "><?php
                        $getLayananWAPengaduan = DB::table('jenis_layanan_wa_pengaduan')->select('id', 'layanan_wa_pengaduan')->get();
                    ?>
                    <a  class="btn btn-primary" href="<?php print_link("layanan_wa_pengaduan/filldatawapengaduannew", true) ?>" >
                    <i class="fa fa-plus"></i>                              
                    Data Awal WA Pengaduan New
                </a>
                <a  class="btn btn-primary" href="<?php print_link("layanan_wa_pengaduan/filldatawapengaduan", true) ?>" >
                <i class="fa fa-plus"></i>                              
                Data Awal WA Pengaduan
            </a></div>
        </div>
        <div class="col-md-auto  " >
            <a  class="btn btn-primary" href="<?php print_link("layanan_wa_pengaduan/add", true) ?>" >
            <i class="fa fa-plus"></i>                              
            Add New Layanan Wa Pengaduan 
        </a>
    </div>
    <div class="col-md-3  " >
        <!-- Page drop down search component -->
        <form  class="search" action="{{ url()->current() }}" method="get">
            <input type="hidden" name="page" value="1" />
            <div class="input-group">
                <input value="<?php echo get_value('search'); ?>" class="form-control page-search" type="text" name="search"  placeholder="Search" />
                <button class="btn btn-primary"><i class="fa fa-search"></i></button>
            </div>
        </form>
    </div>
</div>
</div>
</div>
<?php
    }
?>
<div  class="" >
    <div class="container-fluid">
        <div class="row ">
            <div class="col-md-12 comp-grid " >
                <?php Html::display_page_errors($errors); ?>
                <div  class=" page-content" >
                    <div id="layanan_wa_pengaduan-list-records">
                        <div id="page-main-content" class="table-responsive">
                            <?php Html::page_bread_crumb("/layanan_wa_pengaduan/", $field_name, $field_value); ?>
                            <table class="table table-hover table-striped table-sm text-left">
                                <thead class="table-header ">
                                    <tr>
                                        <th class="td-checkbox">
                                        <label class="form-check-label">
                                        <input class="toggle-check-all form-check-input" type="checkbox" />
                                        </label>
                                        </th>
                                        <th class="td-created" > Created</th>
                                        <th class="td-id_jenis_layanan_wa_pengaduan" > Id Jenis Layanan Wa Pengaduan</th>
                                        <th class="td-jumlah" > Jumlah</th>
                                        <th class="td-modified" > Modified</th>
                                        <th class="td-btn"></th>
                                    </tr>
                                </thead>
                                <?php
                                    if($total_records){
                                ?>
                                <tbody class="page-data">
                                    <!--record-->
                                    <?php
                                        $counter = 0;
                                        foreach($records as $data){
                                        $rec_id = ($data['id'] ? urlencode($data['id']) : null);
                                        $counter++;
                                    ?>
                                    <tr>
                                        <td class=" td-checkbox">
                                            <label class="form-check-label">
                                            <input class="optioncheck form-check-input" name="optioncheck[]" value="<?php echo $data['id'] ?>" type="checkbox" />
                                            </label>
                                        </td>
                                        <!--PageComponentStart-->
                                        <td class="td-created">
                                            <?php echo  $data['created'] ; ?>
                                        </td>
                                        <td class="td-id_jenis_layanan_wa_pengaduan"><?php 
                                            $idJenLayWAPeng = $data['id_jenis_layanan_wa_pengaduan']-1;
                                            echo $getLayananWAPengaduan[$idJenLayWAPeng]->layanan_wa_pengaduan; 
                                        ?></td>
                                        <td class="td-jumlah">
                                            <span  data-step="any" 
                                            data-source='<?php print_link('componentsdata/jumlah_option_list'); ?>' 
                                            data-value="<?php echo $data['jumlah']; ?>" 
                                            data-pk="<?php echo $data['id'] ?>" 
                                            data-url="<?php print_link("layanan_wa_pengaduan/edit/" . urlencode($data['id'])); ?>" 
                                            data-name="jumlah" 
                                            data-title="Enter Jumlah" 
                                            data-placement="left" 
                                            data-toggle="click" 
                                            data-type="number" 
                                            data-mode="popover" 
                                            data-showbuttons="left" 
                                            class="is-editable" >
                                            <?php echo  $data['jumlah'] ; ?>
                                            </span>
                                        </td>
                                        <td class="td-modified">
                                            <?php echo  $data['modified'] ; ?>
                                        </td>
                                        <!--PageComponentEnd-->
                                        <td class="td-btn">
                                            <div class="dropdown" >
                                                <button data-bs-toggle="dropdown" class="dropdown-toggle btn text-primary btn-flat btn-sm">
                                                <i class="fa fa-bars"></i> 
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <a class="dropdown-item "   href="<?php print_link("layanan_wa_pengaduan/view/$rec_id"); ?>" >
                                                    <i class="fa fa-eye"></i> View
                                                </a>
                                                <a class="dropdown-item "   href="<?php print_link("layanan_wa_pengaduan/edit/$rec_id"); ?>" >
                                                <i class="fa fa-edit"></i> Edit
                                            </a>
                                            <a class="dropdown-item record-delete-btn" data-prompt-msg="Are you sure you want to delete this record?" data-display-style="modal" href="<?php print_link("layanan_wa_pengaduan/delete/$rec_id"); ?>" >
                                            <i class="fa fa-times"></i> Delete
                                        </a>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php 
                            }
                        ?>
                        <!--endrecord-->
                    </tbody>
                    <tbody class="search-data"></tbody>
                    <?php
                        }
                        else{
                    ?>
                    <tbody class="page-data">
                        <tr>
                            <td class="bg-light text-center text-muted animated bounce p-3" colspan="1000">
                                <i class="fa fa-ban"></i> No record found
                            </td>
                        </tr>
                    </tbody>
                    <?php
                        }
                    ?>
                </table>
            </div>
            <?php
                if($show_footer){
            ?>
            <div class=" mt-3">
                <div class="row align-items-center justify-content-between">    
                    <div class="col-md-auto justify-content-center">    
                        <div class="d-flex justify-content-start">  
                            <button data-prompt-msg="Are you sure you want to delete these records?" data-display-style="modal" data-url="<?php print_link("layanan_wa_pengaduan/delete/{sel_ids}"); ?>" class="btn btn-sm btn-danger btn-delete-selected d-none">
                            <i class="fa fa-times"></i> Delete Selected
                            </button>
                            <div class="dropup export-btn-holder mx-1">
                                <button class="btn btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="fa fa-save"></i> 
                                </button>
                                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                    <?php $export_print_link = add_query_params(['export' => 'print']); ?>
                                    <a class="dropdown-item export-link-btn" data-format="print" href="<?php print_link($export_print_link); ?>" target="_blank">
                                    <img src="{{ asset('images/print.png') }}" class="mr-2" /> PRINT
                                </a>
                                <?php $export_pdf_link = add_query_params(['export' => 'pdf']); ?>
                                <a class="dropdown-item export-link-btn" data-format="pdf" href="<?php print_link($export_pdf_link); ?>" target="_blank">
                                <img src="{{ asset('images/pdf.png') }}" class="mr-2" /> PDF
                            </a>
                            <?php $export_csv_link = add_query_params(['export' => 'csv']); ?>
                            <a class="dropdown-item export-link-btn" data-format="csv" href="<?php print_link($export_csv_link); ?>" target="_blank">
                            <img src="{{ asset('/images/csv.png') }}" class="mr-2" /> CSV
                        </a>
                        <?php $export_excel_link = add_query_params(['export' => 'excel']); ?>
                        <a class="dropdown-item export-link-btn" data-format="excel" href="<?php print_link($export_excel_link); ?>" target="_blank">
                        <img src="{{ asset('images/xsl.png') }}" class="mr-2" /> EXCEL
                    </a>
                </div>
            </div>
            <?php Html :: import_form('layanan_wa_pengaduan/importdata' , "Import Data", 'CSV , JSON'); ?>
        </div>
    </div>
    <div class="col">   
        <?php
            if($show_pagination == true){
            $pager = new Pagination($total_records, $record_count);
            $pager->show_page_count = false;
            $pager->show_record_count = true;
            $pager->show_page_limit =false;
            $pager->limit = $limit;
            $pager->show_page_number_list = true;
            $pager->pager_link_range=5;
            $pager->render();
            }
        ?>
    </div>
</div>
</div>
<?php
    }
?>
</div>
</div>
</div>
</div>
</div>
</div>
</section>
@endsection
<!-- Page custom css -->
@section('pagecss')
<style>

</style>
@endsection
<!-- Page custom js -->
@section('pagejs')
<script>
    <!--pageautofill-->
$(document).ready(function(){
	// custom javascript | jquery codes
});

</script>
@endsection
