<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



	Route::get('', 'IndexController@index')->name('index')->middleware(['redirect.to.home']);
	Route::get('index/login', 'IndexController@login')->name('login');
	
	Route::post('auth/login', 'AuthController@login')->name('auth.login');
	Route::any('auth/logout', 'AuthController@logout')->name('logout')->middleware(['auth']);

	Route::get('auth/accountcreated', 'AuthController@accountcreated')->name('accountcreated');
	Route::get('auth/accountpending', 'AuthController@accountpending')->name('accountpending');
	Route::get('auth/accountblocked', 'AuthController@accountblocked')->name('accountblocked');
	Route::get('auth/accountinactive', 'AuthController@accountinactive')->name('accountinactive');


	
	Route::get('layanan_kecamatan/customchart', 'Layanan_KecamatanController@customchart');
	Route::get('layanan_kecamatan/customchart/{filter?}/{filtervalue?}', 'Layanan_KecamatanController@customchart');	
	Route::get('auth/register', 'AuthController@register')->name('auth.register')->middleware(['redirect.to.home']);
	Route::post('auth/register', 'AuthController@register_store')->name('auth.register_store');
		
	Route::post('auth/login', 'AuthController@login')->name('auth.login');
	Route::get('auth/password/forgotpassword', 'AuthController@showForgotPassword')->name('password.forgotpassword');
	Route::post('auth/password/sendemail', 'AuthController@sendPasswordResetLink')->name('password.email');
	Route::get('auth/password/reset', 'AuthController@showResetPassword')->name('password.reset.token');
	Route::post('auth/password/resetpassword', 'AuthController@resetPassword')->name('password.resetpassword');
	Route::get('auth/password/resetcompleted', 'AuthController@passwordResetCompleted')->name('password.resetcompleted');
	Route::get('auth/password/linksent', 'AuthController@passwordResetLinkSent')->name('password.resetlinksent');
	

/**
 * All routes which requires auth
 */
Route::middleware(['auth'])->group(function () {
		
	Route::get('home', 'HomeController@index')->name('home');

	

/* routes for Jenis_Kecamatan Controller */	
	Route::get('jenis_kecamatan', 'Jenis_KecamatanController@index')->name('jenis_kecamatan.index');
	Route::get('jenis_kecamatan/index', 'Jenis_KecamatanController@index')->name('jenis_kecamatan.index');
	Route::get('jenis_kecamatan/index/{filter?}/{filtervalue?}', 'Jenis_KecamatanController@index')->name('jenis_kecamatan.index');	
	Route::get('jenis_kecamatan/view/{rec_id}', 'Jenis_KecamatanController@view')->name('jenis_kecamatan.view');	
	Route::get('jenis_kecamatan/add', 'Jenis_KecamatanController@add')->name('jenis_kecamatan.add');
	Route::post('jenis_kecamatan/add', 'Jenis_KecamatanController@store')->name('jenis_kecamatan.store');
		
	Route::any('jenis_kecamatan/edit/{rec_id}', 'Jenis_KecamatanController@edit')->name('jenis_kecamatan.edit');	
	Route::get('jenis_kecamatan/delete/{rec_id}', 'Jenis_KecamatanController@delete');

/* routes for Jenis_Layanan_Adm_Gsd Controller */	
	Route::get('jenis_layanan_adm_gsd', 'Jenis_Layanan_Adm_GsdController@index')->name('jenis_layanan_adm_gsd.index');
	Route::get('jenis_layanan_adm_gsd/index', 'Jenis_Layanan_Adm_GsdController@index')->name('jenis_layanan_adm_gsd.index');
	Route::get('jenis_layanan_adm_gsd/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_Adm_GsdController@index')->name('jenis_layanan_adm_gsd.index');	
	Route::get('jenis_layanan_adm_gsd/view/{rec_id}', 'Jenis_Layanan_Adm_GsdController@view')->name('jenis_layanan_adm_gsd.view');	
	Route::get('jenis_layanan_adm_gsd/add', 'Jenis_Layanan_Adm_GsdController@add')->name('jenis_layanan_adm_gsd.add');
	Route::post('jenis_layanan_adm_gsd/add', 'Jenis_Layanan_Adm_GsdController@store')->name('jenis_layanan_adm_gsd.store');
		
	Route::any('jenis_layanan_adm_gsd/edit/{rec_id}', 'Jenis_Layanan_Adm_GsdController@edit')->name('jenis_layanan_adm_gsd.edit');	
	Route::get('jenis_layanan_adm_gsd/delete/{rec_id}', 'Jenis_Layanan_Adm_GsdController@delete');

/* routes for Jenis_Layanan_Cetak_Kia_Ktp_Paket Controller */	
	Route::get('jenis_layanan_cetak_kia_ktp_paket', 'Jenis_Layanan_Cetak_Kia_Ktp_PaketController@index')->name('jenis_layanan_cetak_kia_ktp_paket.index');
	Route::get('jenis_layanan_cetak_kia_ktp_paket/index', 'Jenis_Layanan_Cetak_Kia_Ktp_PaketController@index')->name('jenis_layanan_cetak_kia_ktp_paket.index');
	Route::get('jenis_layanan_cetak_kia_ktp_paket/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_Cetak_Kia_Ktp_PaketController@index')->name('jenis_layanan_cetak_kia_ktp_paket.index');	
	Route::get('jenis_layanan_cetak_kia_ktp_paket/view/{rec_id}', 'Jenis_Layanan_Cetak_Kia_Ktp_PaketController@view')->name('jenis_layanan_cetak_kia_ktp_paket.view');	
	Route::get('jenis_layanan_cetak_kia_ktp_paket/add', 'Jenis_Layanan_Cetak_Kia_Ktp_PaketController@add')->name('jenis_layanan_cetak_kia_ktp_paket.add');
	Route::post('jenis_layanan_cetak_kia_ktp_paket/add', 'Jenis_Layanan_Cetak_Kia_Ktp_PaketController@store')->name('jenis_layanan_cetak_kia_ktp_paket.store');
		
	Route::any('jenis_layanan_cetak_kia_ktp_paket/edit/{rec_id}', 'Jenis_Layanan_Cetak_Kia_Ktp_PaketController@edit')->name('jenis_layanan_cetak_kia_ktp_paket.edit');	
	Route::get('jenis_layanan_cetak_kia_ktp_paket/delete/{rec_id}', 'Jenis_Layanan_Cetak_Kia_Ktp_PaketController@delete');

/* routes for Jenis_Layanan_Gsd Controller */	
	Route::get('jenis_layanan_gsd', 'Jenis_Layanan_GsdController@index')->name('jenis_layanan_gsd.index');
	Route::get('jenis_layanan_gsd/index', 'Jenis_Layanan_GsdController@index')->name('jenis_layanan_gsd.index');
	Route::get('jenis_layanan_gsd/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_GsdController@index')->name('jenis_layanan_gsd.index');	
	Route::get('jenis_layanan_gsd/view/{rec_id}', 'Jenis_Layanan_GsdController@view')->name('jenis_layanan_gsd.view');	
	Route::get('jenis_layanan_gsd/add', 'Jenis_Layanan_GsdController@add')->name('jenis_layanan_gsd.add');
	Route::post('jenis_layanan_gsd/add', 'Jenis_Layanan_GsdController@store')->name('jenis_layanan_gsd.store');
		
	Route::any('jenis_layanan_gsd/edit/{rec_id}', 'Jenis_Layanan_GsdController@edit')->name('jenis_layanan_gsd.edit');	
	Route::get('jenis_layanan_gsd/delete/{rec_id}', 'Jenis_Layanan_GsdController@delete');

/* routes for Jenis_Layanan_Informasi_Offline Controller */	
	Route::get('jenis_layanan_informasi_offline', 'Jenis_Layanan_Informasi_OfflineController@index')->name('jenis_layanan_informasi_offline.index');
	Route::get('jenis_layanan_informasi_offline/index', 'Jenis_Layanan_Informasi_OfflineController@index')->name('jenis_layanan_informasi_offline.index');
	Route::get('jenis_layanan_informasi_offline/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_Informasi_OfflineController@index')->name('jenis_layanan_informasi_offline.index');	
	Route::get('jenis_layanan_informasi_offline/view/{rec_id}', 'Jenis_Layanan_Informasi_OfflineController@view')->name('jenis_layanan_informasi_offline.view');	
	Route::get('jenis_layanan_informasi_offline/add', 'Jenis_Layanan_Informasi_OfflineController@add')->name('jenis_layanan_informasi_offline.add');
	Route::post('jenis_layanan_informasi_offline/add', 'Jenis_Layanan_Informasi_OfflineController@store')->name('jenis_layanan_informasi_offline.store');
		
	Route::any('jenis_layanan_informasi_offline/edit/{rec_id}', 'Jenis_Layanan_Informasi_OfflineController@edit')->name('jenis_layanan_informasi_offline.edit');	
	Route::get('jenis_layanan_informasi_offline/delete/{rec_id}', 'Jenis_Layanan_Informasi_OfflineController@delete');

/* routes for Jenis_Layanan_Kecamatan Controller */	
	Route::get('jenis_layanan_kecamatan', 'Jenis_Layanan_KecamatanController@index')->name('jenis_layanan_kecamatan.index');
	Route::get('jenis_layanan_kecamatan/index', 'Jenis_Layanan_KecamatanController@index')->name('jenis_layanan_kecamatan.index');
	Route::get('jenis_layanan_kecamatan/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_KecamatanController@index')->name('jenis_layanan_kecamatan.index');	
	Route::get('jenis_layanan_kecamatan/view/{rec_id}', 'Jenis_Layanan_KecamatanController@view')->name('jenis_layanan_kecamatan.view');	
	Route::get('jenis_layanan_kecamatan/add', 'Jenis_Layanan_KecamatanController@add')->name('jenis_layanan_kecamatan.add');
	Route::post('jenis_layanan_kecamatan/add', 'Jenis_Layanan_KecamatanController@store')->name('jenis_layanan_kecamatan.store');
		
	Route::any('jenis_layanan_kecamatan/edit/{rec_id}', 'Jenis_Layanan_KecamatanController@edit')->name('jenis_layanan_kecamatan.edit');	
	Route::get('jenis_layanan_kecamatan/delete/{rec_id}', 'Jenis_Layanan_KecamatanController@delete');

/* routes for Jenis_Layanan_Pengambilan Controller */	
	Route::get('jenis_layanan_pengambilan', 'Jenis_Layanan_PengambilanController@index')->name('jenis_layanan_pengambilan.index');
	Route::get('jenis_layanan_pengambilan/index', 'Jenis_Layanan_PengambilanController@index')->name('jenis_layanan_pengambilan.index');
	Route::get('jenis_layanan_pengambilan/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_PengambilanController@index')->name('jenis_layanan_pengambilan.index');	
	Route::get('jenis_layanan_pengambilan/view/{rec_id}', 'Jenis_Layanan_PengambilanController@view')->name('jenis_layanan_pengambilan.view');	
	Route::get('jenis_layanan_pengambilan/add', 'Jenis_Layanan_PengambilanController@add')->name('jenis_layanan_pengambilan.add');
	Route::post('jenis_layanan_pengambilan/add', 'Jenis_Layanan_PengambilanController@store')->name('jenis_layanan_pengambilan.store');
		
	Route::any('jenis_layanan_pengambilan/edit/{rec_id}', 'Jenis_Layanan_PengambilanController@edit')->name('jenis_layanan_pengambilan.edit');	
	Route::get('jenis_layanan_pengambilan/delete/{rec_id}', 'Jenis_Layanan_PengambilanController@delete');

/* routes for Jenis_Layanan_Verifikator Controller */	
	Route::get('jenis_layanan_verifikator', 'Jenis_Layanan_VerifikatorController@index')->name('jenis_layanan_verifikator.index');
	Route::get('jenis_layanan_verifikator/index', 'Jenis_Layanan_VerifikatorController@index')->name('jenis_layanan_verifikator.index');
	Route::get('jenis_layanan_verifikator/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_VerifikatorController@index')->name('jenis_layanan_verifikator.index');	
	Route::get('jenis_layanan_verifikator/view/{rec_id}', 'Jenis_Layanan_VerifikatorController@view')->name('jenis_layanan_verifikator.view');	
	Route::get('jenis_layanan_verifikator/add', 'Jenis_Layanan_VerifikatorController@add')->name('jenis_layanan_verifikator.add');
	Route::post('jenis_layanan_verifikator/add', 'Jenis_Layanan_VerifikatorController@store')->name('jenis_layanan_verifikator.store');
		
	Route::any('jenis_layanan_verifikator/edit/{rec_id}', 'Jenis_Layanan_VerifikatorController@edit')->name('jenis_layanan_verifikator.edit');	
	Route::get('jenis_layanan_verifikator/delete/{rec_id}', 'Jenis_Layanan_VerifikatorController@delete');

/* routes for Jenis_Layanan_Wa_Pengaduan Controller */	
	Route::get('jenis_layanan_wa_pengaduan', 'Jenis_Layanan_Wa_PengaduanController@index')->name('jenis_layanan_wa_pengaduan.index');
	Route::get('jenis_layanan_wa_pengaduan/index', 'Jenis_Layanan_Wa_PengaduanController@index')->name('jenis_layanan_wa_pengaduan.index');
	Route::get('jenis_layanan_wa_pengaduan/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_Wa_PengaduanController@index')->name('jenis_layanan_wa_pengaduan.index');	
	Route::get('jenis_layanan_wa_pengaduan/view/{rec_id}', 'Jenis_Layanan_Wa_PengaduanController@view')->name('jenis_layanan_wa_pengaduan.view');	
	Route::get('jenis_layanan_wa_pengaduan/add', 'Jenis_Layanan_Wa_PengaduanController@add')->name('jenis_layanan_wa_pengaduan.add');
	Route::post('jenis_layanan_wa_pengaduan/add', 'Jenis_Layanan_Wa_PengaduanController@store')->name('jenis_layanan_wa_pengaduan.store');
		
	Route::any('jenis_layanan_wa_pengaduan/edit/{rec_id}', 'Jenis_Layanan_Wa_PengaduanController@edit')->name('jenis_layanan_wa_pengaduan.edit');	
	Route::get('jenis_layanan_wa_pengaduan/delete/{rec_id}', 'Jenis_Layanan_Wa_PengaduanController@delete');

/* routes for Jenis_Layanan_Wa_Pengelola_Sistem Controller */	
	Route::get('jenis_layanan_wa_pengelola_sistem', 'Jenis_Layanan_Wa_Pengelola_SistemController@index')->name('jenis_layanan_wa_pengelola_sistem.index');
	Route::get('jenis_layanan_wa_pengelola_sistem/index', 'Jenis_Layanan_Wa_Pengelola_SistemController@index')->name('jenis_layanan_wa_pengelola_sistem.index');
	Route::get('jenis_layanan_wa_pengelola_sistem/index/{filter?}/{filtervalue?}', 'Jenis_Layanan_Wa_Pengelola_SistemController@index')->name('jenis_layanan_wa_pengelola_sistem.index');	
	Route::get('jenis_layanan_wa_pengelola_sistem/view/{rec_id}', 'Jenis_Layanan_Wa_Pengelola_SistemController@view')->name('jenis_layanan_wa_pengelola_sistem.view');	
	Route::get('jenis_layanan_wa_pengelola_sistem/add', 'Jenis_Layanan_Wa_Pengelola_SistemController@add')->name('jenis_layanan_wa_pengelola_sistem.add');
	Route::post('jenis_layanan_wa_pengelola_sistem/add', 'Jenis_Layanan_Wa_Pengelola_SistemController@store')->name('jenis_layanan_wa_pengelola_sistem.store');
		
	Route::any('jenis_layanan_wa_pengelola_sistem/edit/{rec_id}', 'Jenis_Layanan_Wa_Pengelola_SistemController@edit')->name('jenis_layanan_wa_pengelola_sistem.edit');	
	Route::get('jenis_layanan_wa_pengelola_sistem/delete/{rec_id}', 'Jenis_Layanan_Wa_Pengelola_SistemController@delete');

/* routes for Layanan_Adm_Gsd Controller */	
	Route::get('layanan_adm_gsd', 'Layanan_Adm_GsdController@index')->name('layanan_adm_gsd.index');
	Route::get('layanan_adm_gsd/index', 'Layanan_Adm_GsdController@index')->name('layanan_adm_gsd.index');
	Route::get('layanan_adm_gsd/index/{filter?}/{filtervalue?}', 'Layanan_Adm_GsdController@index')->name('layanan_adm_gsd.index');	
	Route::post('layanan_adm_gsd/importdata', 'Layanan_Adm_GsdController@importdata');	
	Route::get('layanan_adm_gsd/view/{rec_id}', 'Layanan_Adm_GsdController@view')->name('layanan_adm_gsd.view');	
	Route::get('layanan_adm_gsd/add', 'Layanan_Adm_GsdController@add')->name('layanan_adm_gsd.add');
	Route::post('layanan_adm_gsd/add', 'Layanan_Adm_GsdController@store')->name('layanan_adm_gsd.store');
		
	Route::any('layanan_adm_gsd/edit/{rec_id}', 'Layanan_Adm_GsdController@edit')->name('layanan_adm_gsd.edit');Route::any('layanan_adm_gsd/editfield/{rec_id}', 'Layanan_Adm_GsdController@editfield');	
	Route::get('layanan_adm_gsd/delete/{rec_id}', 'Layanan_Adm_GsdController@delete');

/* routes for Layanan_Cetak_Kia_Ktp_Paket Controller */	
	Route::get('layanan_cetak_kia_ktp_paket', 'Layanan_Cetak_Kia_Ktp_PaketController@index')->name('layanan_cetak_kia_ktp_paket.index');
	Route::get('layanan_cetak_kia_ktp_paket/index', 'Layanan_Cetak_Kia_Ktp_PaketController@index')->name('layanan_cetak_kia_ktp_paket.index');
	Route::get('layanan_cetak_kia_ktp_paket/index/{filter?}/{filtervalue?}', 'Layanan_Cetak_Kia_Ktp_PaketController@index')->name('layanan_cetak_kia_ktp_paket.index');	
	Route::post('layanan_cetak_kia_ktp_paket/importdata', 'Layanan_Cetak_Kia_Ktp_PaketController@importdata');	
	Route::get('layanan_cetak_kia_ktp_paket/view/{rec_id}', 'Layanan_Cetak_Kia_Ktp_PaketController@view')->name('layanan_cetak_kia_ktp_paket.view');	
	Route::get('layanan_cetak_kia_ktp_paket/add', 'Layanan_Cetak_Kia_Ktp_PaketController@add')->name('layanan_cetak_kia_ktp_paket.add');
	Route::post('layanan_cetak_kia_ktp_paket/add', 'Layanan_Cetak_Kia_Ktp_PaketController@store')->name('layanan_cetak_kia_ktp_paket.store');
		
	Route::any('layanan_cetak_kia_ktp_paket/edit/{rec_id}', 'Layanan_Cetak_Kia_Ktp_PaketController@edit')->name('layanan_cetak_kia_ktp_paket.edit');Route::any('layanan_cetak_kia_ktp_paket/editfield/{rec_id}', 'Layanan_Cetak_Kia_Ktp_PaketController@editfield');	
	Route::get('layanan_cetak_kia_ktp_paket/delete/{rec_id}', 'Layanan_Cetak_Kia_Ktp_PaketController@delete');

/* routes for Layanan_Gsd Controller */	
	Route::get('layanan_gsd', 'Layanan_GsdController@index')->name('layanan_gsd.index');
	Route::get('layanan_gsd/index', 'Layanan_GsdController@index')->name('layanan_gsd.index');
	Route::get('layanan_gsd/index/{filter?}/{filtervalue?}', 'Layanan_GsdController@index')->name('layanan_gsd.index');	
	Route::post('layanan_gsd/importdata', 'Layanan_GsdController@importdata');	
	Route::get('layanan_gsd/view/{rec_id}', 'Layanan_GsdController@view')->name('layanan_gsd.view');	
	Route::get('layanan_gsd/add', 'Layanan_GsdController@add')->name('layanan_gsd.add');
	Route::post('layanan_gsd/add', 'Layanan_GsdController@store')->name('layanan_gsd.store');
		
	Route::any('layanan_gsd/edit/{rec_id}', 'Layanan_GsdController@edit')->name('layanan_gsd.edit');Route::any('layanan_gsd/editfield/{rec_id}', 'Layanan_GsdController@editfield');	
	Route::get('layanan_gsd/delete/{rec_id}', 'Layanan_GsdController@delete');

/* routes for Layanan_Informasi_Offline Controller */	
	Route::get('layanan_informasi_offline', 'Layanan_Informasi_OfflineController@index')->name('layanan_informasi_offline.index');
	Route::get('layanan_informasi_offline/index', 'Layanan_Informasi_OfflineController@index')->name('layanan_informasi_offline.index');
	Route::get('layanan_informasi_offline/index/{filter?}/{filtervalue?}', 'Layanan_Informasi_OfflineController@index')->name('layanan_informasi_offline.index');	
	Route::post('layanan_informasi_offline/importdata', 'Layanan_Informasi_OfflineController@importdata');	
	Route::get('layanan_informasi_offline/view/{rec_id}', 'Layanan_Informasi_OfflineController@view')->name('layanan_informasi_offline.view');	
	Route::get('layanan_informasi_offline/add', 'Layanan_Informasi_OfflineController@add')->name('layanan_informasi_offline.add');
	Route::post('layanan_informasi_offline/add', 'Layanan_Informasi_OfflineController@store')->name('layanan_informasi_offline.store');
		
	Route::any('layanan_informasi_offline/edit/{rec_id}', 'Layanan_Informasi_OfflineController@edit')->name('layanan_informasi_offline.edit');Route::any('layanan_informasi_offline/editfield/{rec_id}', 'Layanan_Informasi_OfflineController@editfield');	
	Route::get('layanan_informasi_offline/delete/{rec_id}', 'Layanan_Informasi_OfflineController@delete');

/* routes for Layanan_Kecamatan Controller */	
	Route::get('layanan_kecamatan', 'Layanan_KecamatanController@index')->name('layanan_kecamatan.index');
	Route::get('layanan_kecamatan/index', 'Layanan_KecamatanController@index')->name('layanan_kecamatan.index');
	Route::get('layanan_kecamatan/index/{filter?}/{filtervalue?}', 'Layanan_KecamatanController@index')->name('layanan_kecamatan.index');	
	Route::post('layanan_kecamatan/importdata', 'Layanan_KecamatanController@importdata');	
	Route::get('layanan_kecamatan/view/{rec_id}', 'Layanan_KecamatanController@view')->name('layanan_kecamatan.view');	
	Route::get('layanan_kecamatan/add', 'Layanan_KecamatanController@add')->name('layanan_kecamatan.add');
	Route::post('layanan_kecamatan/add', 'Layanan_KecamatanController@store')->name('layanan_kecamatan.store');
		
	Route::any('layanan_kecamatan/edit/{rec_id}', 'Layanan_KecamatanController@edit')->name('layanan_kecamatan.edit');Route::any('layanan_kecamatan/editfield/{rec_id}', 'Layanan_KecamatanController@editfield');	
	Route::get('layanan_kecamatan/delete/{rec_id}', 'Layanan_KecamatanController@delete');

/* routes for Layanan_Pengambilan Controller */	
	Route::get('layanan_pengambilan', 'Layanan_PengambilanController@index')->name('layanan_pengambilan.index');
	Route::get('layanan_pengambilan/index', 'Layanan_PengambilanController@index')->name('layanan_pengambilan.index');
	Route::get('layanan_pengambilan/index/{filter?}/{filtervalue?}', 'Layanan_PengambilanController@index')->name('layanan_pengambilan.index');	
	Route::post('layanan_pengambilan/importdata', 'Layanan_PengambilanController@importdata');	
	Route::get('layanan_pengambilan/view/{rec_id}', 'Layanan_PengambilanController@view')->name('layanan_pengambilan.view');	
	Route::get('layanan_pengambilan/add', 'Layanan_PengambilanController@add')->name('layanan_pengambilan.add');
	Route::post('layanan_pengambilan/add', 'Layanan_PengambilanController@store')->name('layanan_pengambilan.store');
		
	Route::any('layanan_pengambilan/edit/{rec_id}', 'Layanan_PengambilanController@edit')->name('layanan_pengambilan.edit');Route::any('layanan_pengambilan/editfield/{rec_id}', 'Layanan_PengambilanController@editfield');	
	Route::get('layanan_pengambilan/delete/{rec_id}', 'Layanan_PengambilanController@delete');

/* routes for Layanan_Verifikator Controller */	
	Route::get('layanan_verifikator', 'Layanan_VerifikatorController@index')->name('layanan_verifikator.index');
	Route::get('layanan_verifikator/index', 'Layanan_VerifikatorController@index')->name('layanan_verifikator.index');
	Route::get('layanan_verifikator/index/{filter?}/{filtervalue?}', 'Layanan_VerifikatorController@index')->name('layanan_verifikator.index');	
	Route::post('layanan_verifikator/importdata', 'Layanan_VerifikatorController@importdata');	
	Route::get('layanan_verifikator/view/{rec_id}', 'Layanan_VerifikatorController@view')->name('layanan_verifikator.view');	
	Route::get('layanan_verifikator/add', 'Layanan_VerifikatorController@add')->name('layanan_verifikator.add');
	Route::post('layanan_verifikator/add', 'Layanan_VerifikatorController@store')->name('layanan_verifikator.store');
		
	Route::any('layanan_verifikator/edit/{rec_id}', 'Layanan_VerifikatorController@edit')->name('layanan_verifikator.edit');Route::any('layanan_verifikator/editfield/{rec_id}', 'Layanan_VerifikatorController@editfield');	
	Route::get('layanan_verifikator/delete/{rec_id}', 'Layanan_VerifikatorController@delete');

/* routes for Layanan_Wa_Pengaduan Controller */	
	Route::get('layanan_wa_pengaduan', 'Layanan_Wa_PengaduanController@index')->name('layanan_wa_pengaduan.index');
	Route::get('layanan_wa_pengaduan/index', 'Layanan_Wa_PengaduanController@index')->name('layanan_wa_pengaduan.index');
	Route::get('layanan_wa_pengaduan/index/{filter?}/{filtervalue?}', 'Layanan_Wa_PengaduanController@index')->name('layanan_wa_pengaduan.index');	
	Route::post('layanan_wa_pengaduan/importdata', 'Layanan_Wa_PengaduanController@importdata');	
	Route::get('layanan_wa_pengaduan/view/{rec_id}', 'Layanan_Wa_PengaduanController@view')->name('layanan_wa_pengaduan.view');	
	Route::get('layanan_wa_pengaduan/add', 'Layanan_Wa_PengaduanController@add')->name('layanan_wa_pengaduan.add');
	Route::post('layanan_wa_pengaduan/add', 'Layanan_Wa_PengaduanController@store')->name('layanan_wa_pengaduan.store');
		
	Route::any('layanan_wa_pengaduan/edit/{rec_id}', 'Layanan_Wa_PengaduanController@edit')->name('layanan_wa_pengaduan.edit');Route::any('layanan_wa_pengaduan/editfield/{rec_id}', 'Layanan_Wa_PengaduanController@editfield');	
	Route::get('layanan_wa_pengaduan/delete/{rec_id}', 'Layanan_Wa_PengaduanController@delete');

/* routes for Layanan_Wa_Pengelola_Sistem Controller */	
	Route::get('layanan_wa_pengelola_sistem', 'Layanan_Wa_Pengelola_SistemController@index')->name('layanan_wa_pengelola_sistem.index');
	Route::get('layanan_wa_pengelola_sistem/index', 'Layanan_Wa_Pengelola_SistemController@index')->name('layanan_wa_pengelola_sistem.index');
	Route::get('layanan_wa_pengelola_sistem/index/{filter?}/{filtervalue?}', 'Layanan_Wa_Pengelola_SistemController@index')->name('layanan_wa_pengelola_sistem.index');	
	Route::post('layanan_wa_pengelola_sistem/importdata', 'Layanan_Wa_Pengelola_SistemController@importdata');	
	Route::get('layanan_wa_pengelola_sistem/view/{rec_id}', 'Layanan_Wa_Pengelola_SistemController@view')->name('layanan_wa_pengelola_sistem.view');	
	Route::get('layanan_wa_pengelola_sistem/add', 'Layanan_Wa_Pengelola_SistemController@add')->name('layanan_wa_pengelola_sistem.add');
	Route::post('layanan_wa_pengelola_sistem/add', 'Layanan_Wa_Pengelola_SistemController@store')->name('layanan_wa_pengelola_sistem.store');
		
	Route::any('layanan_wa_pengelola_sistem/edit/{rec_id}', 'Layanan_Wa_Pengelola_SistemController@edit')->name('layanan_wa_pengelola_sistem.edit');Route::any('layanan_wa_pengelola_sistem/editfield/{rec_id}', 'Layanan_Wa_Pengelola_SistemController@editfield');	
	Route::get('layanan_wa_pengelola_sistem/delete/{rec_id}', 'Layanan_Wa_Pengelola_SistemController@delete');

/* routes for User Controller */	
	Route::get('user', 'UserController@index')->name('user.index');
	Route::get('user/index', 'UserController@index')->name('user.index');
	Route::get('user/index/{filter?}/{filtervalue?}', 'UserController@index')->name('user.index');	
	Route::get('user/view/{rec_id}', 'UserController@view')->name('user.view');	
	Route::any('account/edit', 'AccountController@edit')->name('account.edit');	
	Route::get('account', 'AccountController@index');	
	Route::post('account/changepassword', 'AccountController@changepassword')->name('account.changepassword');	
	Route::get('user/add', 'UserController@add')->name('user.add');
	Route::post('user/add', 'UserController@store')->name('user.store');
		
	Route::any('user/edit/{rec_id}', 'UserController@edit')->name('user.edit');	
	Route::get('user/delete/{rec_id}', 'UserController@delete');	
Route::get('grafik_layanan_kecamatan',  function(Request $request){
		return view("pages.custom.grafik_layanan_kecamatan");
	}
);
	
Route::get('grafik_layanan_verifikator',  function(Request $request){
		return view("pages.custom.grafik_layanan_verifikator");
	}
);

});

	
	Route::get('layanan_kecamatan/filldatadensel', 'layanan_kecamatanController@filldatadensel')->name('layanan_kecamatan.filldatadensel')->middleware(['auth']);	
	Route::get('layanan_kecamatan/filldatadentim', 'layanan_kecamatanController@filldatadentim')->name('layanan_kecamatan.filldatadentim')->middleware(['auth']);	
	Route::get('layanan_kecamatan/filldatadenbar', 'layanan_kecamatanController@filldatadenbar')->name('layanan_kecamatan.filldatadenbar')->middleware(['auth']);	
	Route::get('layanan_kecamatan/filldatadenut', 'layanan_kecamatanController@filldatadenut')->name('layanan_kecamatan.filldatadenut')->middleware(['auth']);	
	Route::get('layanan_kecamatan/filldatadenselnew', 'layanan_kecamatanController@filldatadenselnew')->name('layanan_kecamatan.filldatadenselnew')->middleware(['auth']);	
	Route::get('layanan_kecamatan/filldatadentimnew', 'layanan_kecamatanController@filldatadentimnew')->name('layanan_kecamatan.filldatadentimnew')->middleware(['auth']);	
	Route::get('layanan_kecamatan/filldatadenbarnew', 'layanan_kecamatanController@filldatadenbarnew')->name('layanan_kecamatan.filldatadenbarnew')->middleware(['auth']);	
	Route::get('layanan_kecamatan/filldatadenutnew', 'layanan_kecamatanController@filldatadenutnew')->name('layanan_kecamatan.filldatadenutnew')->middleware(['auth']);	
	Route::get('layanan_verifikator/filldataverifikatornew', 'layanan_verifikatorController@filldataverifikatornew')->name('layanan_verifikator.filldataverifikatornew')->middleware(['auth']);	
	Route::get('layanan_verifikator/filldataverifikator', 'layanan_verifikatorController@filldataverifikator')->name('layanan_verifikator.filldataverifikator')->middleware(['auth']);	
	Route::get('home/grafiklayanankecamatan', 'HomeController@grafiklayanankecamatan')->name('home.grafiklayanankecamatan')->middleware(['auth']);	
	Route::get('layanan_pengambilan/filldatapengambilannew', 'layanan_pengambilanController@filldatapengambilannew')->name('layanan_pengambilan.filldatapengambilannew')->middleware(['auth']);	
	Route::get('layanan_pengambilan/filldatapengambilan', 'layanan_pengambilanController@filldatapengambilan')->name('layanan_pengambilan.filldatapengambilan')->middleware(['auth']);	
	Route::get('layanan_cetak_kia_ktp_paket/filldatacetakkiaktppaketnew', 'layanan_cetak_kia_ktp_paketController@filldatacetakkiaktppaketnew')->name('layanan_cetak_kia_ktp_paket.filldatacetakkiaktppaketnew')->middleware(['auth']);	
	Route::get('layanan_cetak_kia_ktp_paket/filldatacetakkiaktppaket', 'layanan_cetak_kia_ktp_paketController@filldatacetakkiaktppaket')->name('layanan_cetak_kia_ktp_paket.filldatacetakkiaktppaket')->middleware(['auth']);	
	Route::get('layanan_gsd/filldatagsdnew', 'layanan_gsdController@filldatagsdnew')->name('layanan_gsd.filldatagsdnew')->middleware(['auth']);	
	Route::get('layanan_gsd/filldatagsd', 'layanan_gsdController@filldatagsd')->name('layanan_gsd.filldatagsd')->middleware(['auth']);	
	Route::get('layanan_adm_gsd/filldataadmgsdnew', 'layanan_adm_gsdController@filldataadmgsdnew')->name('layanan_adm_gsd.filldataadmgsdnew')->middleware(['auth']);	
	Route::get('layanan_adm_gsd/filldataadmgsd', 'layanan_adm_gsdController@filldataadmgsd')->name('layanan_adm_gsd.filldataadmgsd')->middleware(['auth']);	
	Route::get('layanan_wa_pengaduan/filldatawapengaduannew', 'layanan_wa_pengaduanController@filldatawapengaduannew')->name('layanan_wa_pengaduan.filldatawapengaduannew')->middleware(['auth']);	
	Route::get('layanan_wa_pengaduan/filldatawapengaduan', 'layanan_wa_pengaduanController@filldatawapengaduan')->name('layanan_wa_pengaduan.filldatawapengaduan')->middleware(['auth']);	
	Route::get('layanan_wa_pengelola_sistem/filldatawapengelolasistemnew', 'layanan_wa_pengelola_sistemController@filldatawapengelolasistemnew')->name('layanan_wa_pengelola_sistem.filldatawapengelolasistemnew')->middleware(['auth']);	
	Route::get('layanan_wa_pengelola_sistem/filldatawapengelolasistem', 'layanan_wa_pengelola_sistemController@filldatawapengelolasistem')->name('layanan_wa_pengelola_sistem.filldatawapengelolasistem')->middleware(['auth']);	
	Route::get('layanan_informasi_offline/filldatainformasiofflinenew', 'layanan_informasi_offlineController@filldatainformasiofflinenew')->name('layanan_informasi_offline.filldatainformasiofflinenew')->middleware(['auth']);	
	Route::get('layanan_informasi_offline/filldatainformasioffline', 'layanan_informasi_offlineController@filldatainformasioffline')->name('layanan_informasi_offline.filldatainformasioffline')->middleware(['auth']);
	
Route::get('componentsdata/jumlah_option_list',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->jumlah_option_list($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/user_username_value_exist',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->user_username_value_exist($request);
	}
);
	
Route::get('componentsdata/user_email_value_exist',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->user_email_value_exist($request);
	}
);
	
Route::get('componentsdata/layanan_kecamatan_id_kecamatan_option_list',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->layanan_kecamatan_id_kecamatan_option_list($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_phpsetlocalelc_allididid_idjumlahcetakektpwnistrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_phpsetlocalelc_allididid_idjumlahcetakektpwnistrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahperekamanbarudiatas17tahunstrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahperekamanbarudiatas17tahunstrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahcetakkiastrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahcetakkiastrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_sisablankowniperharistrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_sisablankowniperharistrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_sisablankownaperharistrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_sisablankownaperharistrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/doughnutchart_layananverifikatorhariini',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->doughnutchart_layananverifikatorhariini($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/getcount_denpasarselatan',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->getcount_denpasarselatan($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/getcount_denpasartimur',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->getcount_denpasartimur($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/getcount_denpasarbarat',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->getcount_denpasarbarat($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/getcount_denpasarutara',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->getcount_denpasarutara($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/getcount_cetakkiaektppaket',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->getcount_cetakkiaektppaket($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/getcount_layanangsd',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->getcount_layanangsd($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_phpsetlocalelc_allididid_idjumlahaktakelahiranstrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_phpsetlocalelc_allididid_idjumlahaktakelahiranstrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahaktaperkawinanstrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahaktaperkawinanstrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahaktaperceraianstrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahaktaperceraianstrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahaktakematianstrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahaktakematianstrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahkartukeluargastrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahkartukeluargastrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahsuratpindahstrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahsuratpindahstrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahaktaatausklainnyastrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahaktaatausklainnyastrftimeb($request);
	}
)->middleware(['auth']);
	
Route::get('componentsdata/barchart_jumlahtotallayananstrftimeb',  function(Request $request){
		$compModel = new App\Models\ComponentsData();
		return $compModel->barchart_jumlahtotallayananstrftimeb($request);
	}
)->middleware(['auth']);


Route::post('fileuploader/upload/{fieldname}', 'FileUploaderController@upload');
Route::post('fileuploader/s3upload/{fieldname}', 'FileUploaderController@s3upload');
Route::post('fileuploader/remove_temp_file', 'FileUploaderController@remove_temp_file');


/**
 * All static content routes
 */
Route::get('info/about',  function(){
		return view("pages.info.about");
	}
);
Route::get('info/faq',  function(){
		return view("pages.info.faq");
	}
);

Route::get('info/contact',  function(){
	return view("pages.info.contact");
}
);
Route::get('info/contactsent',  function(){
	return view("pages.info.contactsent");
}
);

Route::post('info/contact',  function(Request $request){
		$request->validate([
			'name' => 'required',
			'email' => 'required|email',
			'message' => 'required'
		]);

		$senderName = $request->name;
		$senderEmail = $request->email;
		$message = $request->message;

		$receiverEmail = config("mail.from.address");

		Mail::send(
			'pages.info.contactemail', [
				'name' => $senderName,
				'email' => $senderEmail,
				'comment' => $message
			],
			function ($mail) use ($senderEmail, $receiverEmail) {
				$mail->from($senderEmail);
				$mail->to($receiverEmail)
					->subject('Contact Form');
			}
		);
		return redirect("info/contactsent");
	}
);


Route::get('info/features',  function(){
		return view("pages.info.features");
	}
);
Route::get('info/privacypolicy',  function(){
		return view("pages.info.privacypolicy");
	}
);
Route::get('info/termsandconditions',  function(){
		return view("pages.info.termsandconditions");
	}
);

Route::get('info/changelocale/{locale}', function ($locale) {
	app()->setlocale($locale);
	session()->put('locale', $locale);
    return redirect()->back();
})->name('info.changelocale');